import './bootstrap';

// Toggle user dropdown menu
document.addEventListener('DOMContentLoaded', () => {
  const btn = document.getElementById('userMenuButton');
  const menu = document.getElementById('userMenuDropdown');
  if (!btn || !menu) return;

  const open = () => {
    menu.classList.remove('hidden');
    btn.setAttribute('aria-expanded', 'true');
  };
  const close = () => {
    menu.classList.add('hidden');
    btn.setAttribute('aria-expanded', 'false');
  };
  const toggle = () => {
    if (menu.classList.contains('hidden')) open(); else close();
  };

  btn.addEventListener('click', (e) => {
    e.stopPropagation();
    toggle();
  });

  // Close on outside click
  document.addEventListener('click', () => {
    if (!menu.classList.contains('hidden')) close();
  });

  // Close on escape key
  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && !menu.classList.contains('hidden')) close();
  });
});