@extends('layouts.app')

@section('title', 'عرض الفاتورة')

@section('content')
<div class="min-h-screen fancy-bg">
    <div class="container mx-auto px-4 md:px-6 lg:px-8 py-10">
        <div class="flex items-center justify-between gap-4 mb-6">
            <h1 class="text-3xl md:text-4xl font-extrabold tracking-tight text-gray-900">عرض الفاتورة</h1>
            <div class="flex items-center gap-3">
                <a href="{{ route('invoices.index') }}" class="btn-secondary inline-flex items-center gap-2"><i class="fa-solid fa-arrow-right text-sm"></i> عودة للقائمة</a>
                <button onclick="window.print()" class="btn-primary inline-flex items-center gap-2"><i class="fa-solid fa-print text-sm"></i> طباعة</button>
                <a href="{{ route('invoices.pdf', $invoice->id) }}" class="btn-secondary inline-flex items-center gap-2"><i class="fa-solid fa-file-pdf text-sm"></i> تحميل PDF</a>
                <form method="POST" action="{{ route('invoices.destroy', $invoice->id) }}" class="inline-block" onsubmit="return confirm('هل أنت متأكد من حذف هذه الفاتورة؟');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn-secondary text-red-700 hover:bg-red-50 inline-flex items-center gap-2" title="حذف">
                        <i class="fa-solid fa-trash text-sm"></i>
                        حذف
                    </button>
                </form>
                <!-- Toggle paid/unpaid status -->
                <form method="POST" action="{{ route('invoices.toggleStatus', $invoice->id) }}" class="inline-block">
                    @csrf
                    <button type="submit" class="btn-secondary inline-flex items-center gap-2 {{ $invoice->status === 'مسدد' ? 'text-red-700 hover:bg-red-50' : 'text-green-700 hover:bg-green-50' }}" title="تبديل حالة الفاتورة">
                        <i class="fa-solid {{ $invoice->status === 'مسدد' ? 'fa-rotate-left' : 'fa-check' }} text-sm"></i>
                        {{ $invoice->status === 'مسدد' ? 'تعيين كغير مسددة' : 'تعيين كمسددة' }}
                    </button>
                </form>
            </div>
        </div>

        <div id="invoice_print_area" class="card shadow-xl ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-6">
            <!-- رأس الشركة -->
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-5 mb-6">
                <div class="flex items-center gap-6">
                    @if(!empty($setting?->company_logo_path))
                        <img src="{{ asset('storage/' . $setting->company_logo_path) }}" alt="شعار الشركة" class="h-24 w-40 md:h-28 md:w-48 rounded-lg object-contain"/>
                    @else
                        <div class="h-24 w-40 md:h-28 md:w-48 rounded-lg bg-neutral-100 flex items-center justify-center text-neutral-400">LOGO</div>
                    @endif
                    <div>
                        <div class="text-2xl md:text-3xl font-extrabold text-gray-900 mb-2">{{ $setting->company_name ?? '—' }}</div>
                        <div class="text-gray-600">العنوان : <span class="font-medium text-gray-900">{{ $setting->company_address ?? '—' }}</span></div>
                        <div class="text-gray-600">رقم ضريبي: <span class="font-medium text-gray-900">{{ $setting->company_tax_number ?? '—' }}</span></div>
                        <div class="text-gray-600">هاتف: <span class="font-medium text-gray-900">{{ $setting->company_phone ?? '—' }}</span></div>
                    </div>
                </div>

                @if(!empty($qrCodeSvg))
                    <div class="shrink-0">
                        <div class="text-xs text-gray-500 text-center mb-1">رمز الفاتورة (ZATCA)</div>
                        <div class="bg-white border rounded-lg p-2">{!! $qrCodeSvg !!}</div>
                    </div>
                @endif
            </div>

            <!-- فاصل كامل العرض -->
            <div class="w-full border-t-2 border-neutral-300 my-8"></div>

            <!-- عنوان الفاتورة بعد الفاصل -->
            <h2 class="text-center text-xl md:text-2xl font-black text-black mb-4">فاتورة ضريبية</h2>

            <!-- معلومات الفاتورة -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <div class="p-4 rounded-lg bg-neutral-50 border">
                    <div class="text-sm text-gray-600">رقم الفاتورة</div>
                    <div class="text-lg font-semibold text-gray-900">{{ $invoice->number }}</div>
                </div>
                <div class="p-4 rounded-lg bg-neutral-50 border">
                    <div class="text-sm text-gray-600">الرقم المرجعي</div>
                    <div class="text-lg font-semibold text-gray-900">{{ 'REF-' . $invoice->id }}</div>
                </div>
                <div class="p-4 rounded-lg bg-neutral-50 border">
                    <div class="text-sm text-gray-600">التاريخ</div>
                    <div class="text-lg font-semibold text-gray-900">{{ $invoice->date ? $invoice->date->toDateString() : '' }}</div>
                </div>
            </div>

            <!-- بيانات العميل -->
            <div class="mb-6">
                <h2 class="text-lg font-bold text-gray-900 mb-3">بيانات العميل</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="p-4 rounded-lg bg-white border">
                        <div class="text-sm text-gray-600">الاسم</div>
                        <div class="text-base font-medium text-gray-900">{{ $invoice->customer_name }}</div>
                    </div>
                    <div class="p-4 rounded-lg bg-white border">
                        <div class="text-sm text-gray-600">رقم الهاتف</div>
                        <div class="text-base font-medium text-gray-900">{{ $invoice->customer_phone }}</div>
                    </div>
                    @if(!empty($invoice->customer_address))
                        <div class="p-4 rounded-lg bg-white border md:col-span-2">
                            <div class="text-sm text-gray-600">العنوان</div>
                            <div class="text-base font-medium text-gray-900">{{ $invoice->customer_address }}</div>
                        </div>
                    @endif
                    @if(!empty($invoice->tax_number))
                        <div class="p-4 rounded-lg bg-white border md:col-span-2">
                            <div class="text-sm text-gray-600">الرقم الضريبي للعميل</div>
                            <div class="text-base font-medium text-gray-900">{{ $invoice->tax_number }}</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- جدول الخدمات -->
            <div class="mb-6">
                <h2 class="text-lg font-bold text-gray-900 mb-3">الخدمات</h2>
                <div class="overflow-hidden rounded-xl border border-neutral-200">
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-neutral-50">
                                <tr class="text-gray-700">
                                    <th class="p-3 text-right w-12">#</th>
                                    <th class="p-3 text-right">الوصف</th>
                                    <th class="p-3 text-right">الكمية</th>
                                    <th class="p-3 text-right">سعر الوحدة</th>
                                    <th class="p-3 text-right">الإجمالي الفرعي</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white">
                                @forelse($invoice->items as $i => $item)
                                    <tr class="border-t">
                                        <td class="p-3 align-middle">{{ $i + 1 }}</td>
                                        <td class="p-3 align-middle">{{ $item->description }}</td>
                                        <td class="p-3 align-middle">{{ $item->quantity }}</td>
                                        <td class="p-3 align-middle">{{ number_format($item->unit_price, 2) }} ر.س</td>
                                        <td class="p-3 align-middle font-semibold text-black">{{ number_format($item->line_total, 2) }} ر.س</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="p-4 text-center text-gray-500">لا توجد بنود لهذه الفاتورة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- ملاحظات الفاتورة -->
            <div class="mb-6">
                <h2 class="text-lg font-bold text-gray-900 mb-3">ملاحظات الفاتورة</h2>
                <div class="p-4 rounded-lg bg-white border text-gray-700 whitespace-pre-line">@if(trim($invoice->notes ?? '') !== ''){{ $invoice->notes }}@else<span class="text-neutral-500">لا توجد ملاحظات</span>@endif</div>
            </div>

            <!-- الإجماليات -->
            <div class="flex flex-col items-end gap-2">
                <div class="w-full md:w-1/2 lg:w-1/3">
                    <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50">
                        <div class="font-semibold text-black">{{ number_format($invoice->subtotal, 2) }} ر.س</div>
                    </div>
                    <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50 mt-2">
                    <div class="text-gray-700">ضريبة القيمة المضافة (15%)</div>
                    <div class="font-semibold text-gray-900">{{ number_format($invoice->tax, 2) }} ر.س</div>
                    </div>
                    <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-violet-50 mt-2">
                    <div class="text-black font-bold">الإجمالي</div>
                    <div class="font-extrabold text-black">{{ number_format($invoice->total, 2) }} ر.س</div>
                    </div>
                </div>
            </div>

            <!-- فوتر الفاتورة داخل الجزئية -->
            <div class="w-full border-t border-neutral-300 mt-6 mb-2"></div>
            <div class="text-center text-sm text-neutral-600">
                جميع الحقوق محفوظة © {{ now()->year }} لـ {{ $setting->company_name ?? '—' }}
            </div>

        </div>
    </div>
</div>
<style>
  @media print {
    /* إخفاء كل شيء باستثناء منطقة الفاتورة */
    body * { visibility: hidden; }
    #invoice_print_area, #invoice_print_area * { visibility: visible; }
    /* تمديد منطقة الطباعة لتملأ الصفحة */
    #invoice_print_area { position: absolute; inset: 0; margin: 0; padding: 0; }

    /* إخفاء عناصر النظام العامة أثناء الطباعة */
    header, footer, nav, .no-print, .btn-primary, .btn-secondary { display: none !important; }
    main.container { padding: 0 !important; }
  }
</style>
@endsection