<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'نظام الفواتير')</title>
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    <meta name="color-scheme" content="dark light">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Alexandria:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
    @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
        @vite(['resources/css/app.css','resources/js/app.js'])
    @else
        <script src="https://cdn.tailwindcss.com"></script>
        <script>
            tailwind.config = { theme: { extend: { fontFamily: { sans: ['Alexandria','system-ui','-apple-system','Segoe UI','Roboto','Noto Sans Arabic','Helvetica Neue','Arial'] } } } };
        </script>
        <style>
            :root { color-scheme: light dark; }
            html[lang="ar"] { direction: rtl; }
            body { background: #f5f5f5; color: #111827; font-family: 'Alexandria', system-ui, -apple-system, Segoe UI, Roboto, 'Noto Sans Arabic', 'Helvetica Neue', Arial; }
            .container { margin: 0 auto; padding: 1rem; max-width: 1200px; }

            .input { width: 100%; border: 1px solid #d1d5db; border-radius: .75rem; padding: .75rem 1rem; background: #fff; }
            .btn-primary { display: inline-flex; align-items: center; justify-content: center; border-radius: .75rem; background-image: linear-gradient(to right, #06b6d4, #4f46e5); color: #fff; font-weight: 600; padding: .75rem 1rem; }
            .btn-secondary { display: inline-flex; align-items: center; justify-content: center; border-radius: .75rem; background: #e5e7eb; color: #111827; font-weight: 600; padding: .75rem 1rem; }
            .navbar { position: sticky; top: 0; z-index: 40; background: rgba(255,255,255,.7); backdrop-filter: blur(6px); border-bottom: 1px solid #e5e7eb; }
            .alert { border-radius: .75rem; border: 1px solid #ef4444; background: #fef2f2; color: #b91c1c; padding: .75rem 1rem; }
        </style>
    @endif
</head>
<body class="min-h-screen">
    @unless (request()->routeIs('login'))
        @include('layouts.partials.header')
    @endunless

    <main class="container py-8 pb-24">
        @if ($errors->any())
            <div class="alert mb-6">
                <ul class="list-disc pr-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @yield('content')
    </main>

    @include('layouts.partials.footer')
</body>
</html>