<?php $__env->startSection('title', 'تعديل عرض سعر'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen fancy-bg">
    <div class="container mx-auto px-4 md:px-6 lg:px-8 py-10">
        <div class="flex items-center justify-between gap-4 mb-8">
            <div>
                <h1 class="text-3xl md:text-4xl font-extrabold tracking-tight text-gray-900">تعديل عرض سعر رقم <?php echo e($quote->number); ?></h1>
                <p class="mt-1 text-gray-600">حافظنا على نفس استايل الفواتير للتناسق</p>
            </div>
            <a href="<?php echo e(route('quotes.show', $quote->id)); ?>" class="btn-secondary">عرض</a>
        </div>

        <div class="card shadow-lg ring-1 ring-neutral-200/70 rounded-2xl p-6">
            <form id="quote_edit_form" action="<?php echo e(route('quotes.update', $quote->id)); ?>" method="POST" class="space-y-8">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <!-- بيانات العميل -->
                <div>
                    <h2 class="text-xl font-bold mb-4">بيانات العميل</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="customer_name" class="block text-sm font-medium text-gray-700">الاسم</label>
                            <input id="customer_name" type="text" name="customer_name" value="<?php echo e($quote->customer_name); ?>" class="input mt-1" placeholder="اسم العميل" required>
                        </div>
                        <div>
                            <label for="customer_phone" class="block text-sm font-medium text-gray-700">رقم الهاتف</label>
                            <input id="customer_phone" type="text" name="customer_phone" value="<?php echo e($quote->customer_phone); ?>" class="input mt-1" placeholder="رقم الهاتف" required>
                        </div>
                        <div>
                            <label for="customer_address" class="block text-sm font-medium text-gray-700">العنوان</label>
                            <input id="customer_address" type="text" name="customer_address" value="<?php echo e($quote->customer_address); ?>" class="input mt-1" placeholder="عنوان العميل">
                        </div>
                        <div>
                            <label for="customer_tax_number" class="block text-sm font-medium text-gray-700">الرقم الضريبي (إن وجد)</label>
                            <input id="customer_tax_number" type="text" name="customer_tax_number" value="<?php echo e($quote->customer_tax_number); ?>" class="input mt-1" placeholder="الرقم الضريبي">
                        </div>
                    </div>
                </div>

                <!-- بيانات العرض -->
                <div>
                    <h2 class="text-xl font-bold mb-4">بيانات العرض</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="number" class="block text-sm font-medium text-gray-700">رقم العرض</label>
                            <input id="number" type="text" name="number" value="<?php echo e($quote->number); ?>" class="input mt-1" placeholder="مثال: Q-001" required>
                        </div>
                        <div>
                            <label for="date" class="block text-sm font-medium text-gray-700">التاريخ</label>
                            <input id="date" type="date" name="date" value="<?php echo e($quote->date); ?>" class="input mt-1" required>
                        </div>
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700">الحالة</label>
                            <select id="status" name="status" class="input mt-1">
                                <option <?php echo e($quote->status === 'مسودة' ? 'selected' : ''); ?>>مسودة</option>
                                <option <?php echo e($quote->status === 'موافق عليه' ? 'selected' : ''); ?>>موافق عليه</option>
                                <option <?php echo e($quote->status === 'مرفوض' ? 'selected' : ''); ?>>مرفوض</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- بنود العرض -->
                <div>
                    <div class="flex items-center justify-between mb-4">
                        <h2 class="text-xl font-bold">بنود العرض</h2>
                        <button id="add_item_btn" type="button" class="btn-secondary">إضافة بند</button>
                    </div>

                    <div class="overflow-hidden rounded-xl border border-neutral-200">
                        <div class="overflow-x-auto">
                            <table class="min-w-full text-sm">
                                <thead class="bg-neutral-50">
                                    <tr class="text-gray-700">
                                        <th class="p-3 text-right w-1/2">الخدمة/الوصف</th>
                                        <th class="p-3 text-right w-24">العدد</th>
                                        <th class="p-3 text-right w-32">سعر القطعة</th>
                                        <th class="p-3 text-right w-32">الإجمالي</th>
                                        <th class="p-3 text-right w-28">إجراء</th>
                                    </tr>
                                </thead>
                                <tbody id="items_body" class="bg-white">
                                    <!-- ستملأ الصفوف تلقائيًا حسب بيانات العرض -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="flex flex-col items-end gap-2 mt-4">
                        <div class="w-full md:w-1/2 lg:w-1/3">
                            <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50">
                                <div class="text-gray-700">الإجمالي الفرعي</div>
                                <div class="font-semibold text-gray-900"><span id="invoice_subtotal">0.00</span> ر.س</div>
                            </div>
                            <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50 mt-2">
                                <div class="text-gray-700">ضريبة القيمة المضافة (15%)</div>
                                <div class="font-semibold text-gray-900"><span id="invoice_tax">0.00</span> ر.س</div>
                            </div>
                            <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-violet-50 mt-2">
                                <div class="text-violet-700 font-bold">الإجمالي</div>
                                <div class="font-extrabold text-violet-700"><span id="invoice_total">0.00</span> ر.س</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3">
                    <button type="submit" id="save_quote_btn" class="btn-primary">حفظ</button>
                    <a href="<?php echo e(route('quotes.show', $quote->id)); ?>" class="btn-secondary">عرض</a>
                </div>
            </form>
        </div>
    </div>
</div>

<template id="item_row_template">
    <tr class="border-t">
        <td class="p-3 align-middle">
            <input type="text" class="input" placeholder="مثال: خدمة صيانة" name="__desc__" required>
        </td>
        <td class="p-3 align-middle">
            <input type="number" class="input item-qty" min="1" step="1" value="1" name="__qty__" required>
        </td>
        <td class="p-3 align-middle">
            <input type="number" class="input item-price" min="0" step="0.01" value="0.00" name="__price__" required>
        </td>
        <td class="p-3 align-middle">
            <input type="text" class="input item-total bg-neutral-50" value="0.00" readonly>
        </td>
        <td class="p-3 align-middle">
            <button type="button" class="btn-secondary btn-delete">حذف</button>
        </td>
    </tr>
</template>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    let itemIndex = 0;
    const itemsBody = document.getElementById('items_body');
    const addItemBtn = document.getElementById('add_item_btn');
    const subtotalEl = document.getElementById('invoice_subtotal');
    const taxEl = document.getElementById('invoice_tax');
    const totalEl = document.getElementById('invoice_total');
    const saveBtn = document.getElementById('save_quote_btn');
    const form = document.getElementById('quote_edit_form');

    const VAT_RATE = 0.15;
    const format = (num) => Number(num || 0).toFixed(2);

    function updateTotals() {
      let subtotal = 0;
      itemsBody.querySelectorAll('.item-total').forEach(el => {
        subtotal += Number(el.value || 0);
      });
      const tax = subtotal * VAT_RATE;
      const total = subtotal + tax;

      subtotalEl.textContent = format(subtotal);
      taxEl.textContent = format(tax);
      totalEl.textContent = format(total);
    }

    function rebindRow(row) {
      const qty = row.querySelector('.item-qty');
      const price = row.querySelector('.item-price');
      const total = row.querySelector('.item-total');
      const del = row.querySelector('.btn-delete');

      function recalc() {
        const q = Number(qty.value || 0);
        const p = Number(price.value || 0);
        total.value = format(q * p);
        updateTotals();
      }

      qty.addEventListener('input', recalc);
      price.addEventListener('input', recalc);
      del.addEventListener('click', () => {
        row.remove();
        updateTotals();
      });

      recalc();
    }

    function addItemRow(prefill = null) {
      const tpl = document.getElementById('item_row_template');
      const clone = tpl.content.cloneNode(true);
      const row = clone.querySelector('tr');

      const desc = row.querySelector('input[name="__desc__"]');
      const qty = row.querySelector('input[name="__qty__"]');
      const price = row.querySelector('input[name="__price__"]');

      desc.setAttribute('name', `items[${itemIndex}][description]`);
      qty.setAttribute('name', `items[${itemIndex}][quantity]`);
      price.setAttribute('name', `items[${itemIndex}][unit_price]`);

      if (prefill) {
        desc.value = prefill.description || '';
        qty.value = prefill.quantity != null ? prefill.quantity : 1;
        price.value = prefill.unit_price != null ? Number(prefill.unit_price).toFixed(2) : '0.00';
      }

      itemIndex += 1;

      itemsBody.appendChild(row);
      rebindRow(row);
    }

    addItemBtn.addEventListener('click', () => addItemRow());

    // تعبئة البنود الحالية إن وجدت، وإلا أضف صفًا ابتدائيًا
    const initialItems = <?php echo json_encode($quote->items ?? [], JSON_UNESCAPED_UNICODE | JSON_HEX_TAG); ?>;
    if (Array.isArray(initialItems) && initialItems.length > 0) {
      initialItems.forEach(it => addItemRow({
        description: it.description ?? it['description'],
        quantity: it.quantity ?? it['quantity'],
        unit_price: it.unit_price ?? it['unit_price']
      }));
    } else {
      addItemRow();
    }

    // منع النقر المكرر على زر الحفظ أثناء الإرسال
    form.addEventListener('submit', function() {
      saveBtn.disabled = true;
      saveBtn.textContent = 'جارٍ الحفظ...';
    });
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoicesystem\resources\views/quotes/edit.blade.php ENDPATH**/ ?>