<?php $__env->startSection('title', 'إنشاء فاتورة'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen fancy-bg">
    <div class="container mx-auto px-4 md:px-6 lg:px-8 py-10">
        <div class="flex items-center justify-between gap-4 mb-8">
            <div>
                <h1 class="text-3xl md:text-4xl font-extrabold tracking-tight text-gray-900">إنشاء فاتورة</h1>
                <p class="mt-1 text-gray-600">سجّل بيانات العميل وأضف البنود واحسب الإجمالي بسهولة</p>
            </div>
            <a href="<?php echo e(route('invoices.index')); ?>" class="btn-secondary">رجوع</a>
        </div>

        <div class="card shadow-lg ring-1 ring-neutral-200/70 rounded-2xl p-6">
            <form id="invoice_form" action="<?php echo e(route('invoices.store')); ?>" method="POST" class="space-y-8">
                <?php echo csrf_field(); ?>

                <!-- بيانات العميل -->
                <div>
                    <h2 class="text-xl font-bold mb-4">بيانات العميل</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="customer_name" class="block text-sm font-medium text-gray-700">اسم العميل</label>
                            <input id="customer_name" name="customer_name" type="text" class="input mt-1" placeholder="مثال: شركة الإبداع" required>
                            <?php $__errorArgs = ['customer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div>
                            <label for="customer_phone" class="block text-sm font-medium text-gray-700">رقم الهاتف</label>
                            <input id="customer_phone" name="customer_phone" type="text" class="input mt-1" placeholder="05XXXXXXXX" required>
                            <?php $__errorArgs = ['customer_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div>
                            <label for="customer_address" class="block text-sm font-medium text-gray-700">العنوان (اختياري)</label>
                            <input id="customer_address" name="customer_address" type="text" class="input mt-1" placeholder="المدينة، الشارع، المبنى">
                            <?php $__errorArgs = ['customer_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div>
                            <label for="tax_number" class="block text-sm font-medium text-gray-700">الرقم الضريبي (اختياري)</label>
                            <input id="tax_number" name="tax_number" type="text" class="input mt-1" placeholder="1234567890">
                            <?php $__errorArgs = ['tax_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <!-- بنود الفاتورة -->
                <div>
                    <div class="flex items-center justify-between mb-4">
                        <h2 class="text-xl font-bold">بنود الفاتورة</h2>
                        <button id="add_item_btn" type="button" class="btn-secondary">إضافة بند</button>
                    </div>

                    <div class="overflow-hidden rounded-xl border border-neutral-200">
                        <div class="overflow-x-auto">
                            <table class="min-w-full text-sm">
                                <thead class="bg-neutral-50">
                                    <tr class="text-gray-700">
                                        <th class="p-3 text-right w-1/2">الخدمة/الوصف</th>
                                        <th class="p-3 text-right w-24">العدد</th>
                                        <th class="p-3 text-right w-32">سعر القطعة</th>
                                        <th class="p-3 text-right w-32">الإجمالي</th>
                                        <th class="p-3 text-right w-20">حذف</th>
                                    </tr>
                                </thead>
                                <tbody id="items_body" class="bg-white">
                                    <!-- سيُضاف الصف تلقائيًا عبر JavaScript -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="flex flex-col items-end gap-2 mt-4">
                        <div class="w-full md:w-1/2 lg:w-1/3">
                            <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50">
                                <div class="text-gray-700">الإجمالي الفرعي</div>
                                <div class="font-semibold text-gray-900"><span id="invoice_subtotal">0.00</span> ر.س</div>
                            </div>
                            <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50 mt-2">
                                <div class="text-gray-700">ضريبة القيمة المضافة (15%)</div>
                                <div class="font-semibold text-gray-900"><span id="invoice_tax">0.00</span> ر.س</div>
                            </div>
                            <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-violet-50 mt-2">
                                <div class="text-violet-700 font-bold">الإجمالي</div>
                                <div class="font-extrabold text-violet-700"><span id="invoice_total">0.00</span> ر.س</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- الملاحظات -->
                <div>
                    <h2 class="text-xl font-bold mb-4">ملاحظات على الفاتورة</h2>
                    <textarea id="notes" name="notes" class="input mt-1 h-28" placeholder="اكتب أي ملاحظات إضافية هنا..."></textarea>
                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="flex items-center justify-end gap-3">
                    <a href="<?php echo e(route('invoices.index')); ?>" class="btn-secondary">إلغاء</a>
                    <button id="save_invoice_btn" type="submit" class="btn-primary">حفظ الفاتورة</button>
                </div>
            </form>
        </div>

        <template id="item_row_template">
            <tr class="border-t">
                <td class="p-3 align-middle">
                    <input type="text" class="input" placeholder="مثال: خدمة صيانة" name="__desc__" required>
                </td>
                <td class="p-3 align-middle">
                    <input type="number" class="input item-qty" min="1" step="1" value="1" name="__qty__" required>
                </td>
                <td class="p-3 align-middle">
                    <input type="number" class="input item-price" min="0" step="0.01" value="0.00" name="__price__" required>
                </td>
                <td class="p-3 align-middle">
                    <input type="text" class="input item-total bg-neutral-50" value="0.00" readonly>
                </td>
                <td class="p-3 align-middle">
                    <button type="button" class="btn-secondary btn-delete">حذف</button>
                </td>
            </tr>
        </template>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                let itemIndex = 0;
                const itemsBody = document.getElementById('items_body');
                const addItemBtn = document.getElementById('add_item_btn');
                const invoiceSubtotalEl = document.getElementById('invoice_subtotal');
                const invoiceTaxEl = document.getElementById('invoice_tax');
                const invoiceTotalEl = document.getElementById('invoice_total');
                const saveBtn = document.getElementById('save_invoice_btn');
                const form = document.getElementById('invoice_form');

                const VAT_RATE = 0.15;
                const format = (num) => (Number(num || 0).toFixed(2));

                function updateInvoiceTotal() {
                    let subtotal = 0;
                    itemsBody.querySelectorAll('.item-total').forEach(el => {
                        subtotal += Number(el.value || 0);
                    });
                    const tax = subtotal * VAT_RATE;
                    const total = subtotal + tax;

                    invoiceSubtotalEl.textContent = format(subtotal);
                    invoiceTaxEl.textContent = format(tax);
                    invoiceTotalEl.textContent = format(total);
                }

                function rebindRow(row) {
                    const qty = row.querySelector('.item-qty');
                    const price = row.querySelector('.item-price');
                    const total = row.querySelector('.item-total');
                    const del = row.querySelector('.btn-delete');

                    function recalc() {
                        const q = Number(qty.value || 0);
                        const p = Number(price.value || 0);
                        total.value = format(q * p);
                        updateInvoiceTotal();
                    }

                    qty.addEventListener('input', recalc);
                    price.addEventListener('input', recalc);
                    del.addEventListener('click', () => {
                        row.remove();
                        updateInvoiceTotal();
                    });

                    recalc();
                }

                function addItemRow() {
                    const tpl = document.getElementById('item_row_template');
                    const clone = tpl.content.cloneNode(true);
                    const row = clone.querySelector('tr');

                    // ضبط أسماء الحقول بمؤشرات فريدة لكل صف
                    const desc = row.querySelector('input[name="__desc__"]');
                    const qty = row.querySelector('input[name="__qty__"]');
                    const price = row.querySelector('input[name="__price__"]');

                    desc.setAttribute('name', `items[${itemIndex}][description]`);
                    qty.setAttribute('name', `items[${itemIndex}][quantity]`);
                    price.setAttribute('name', `items[${itemIndex}][unit_price]`);

                    itemIndex += 1;

                    itemsBody.appendChild(row);
                    rebindRow(row);
                }

                addItemBtn.addEventListener('click', addItemRow);

                // أضف صفًا ابتدائيًا
                addItemRow();

                // منع النقر المكرر على زر الحفظ أثناء الإرسال
                form.addEventListener('submit', function() {
                    saveBtn.disabled = true;
                    saveBtn.textContent = 'جارٍ الحفظ...';
                });
            });
        </script>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoicesystem\resources\views/invoices/create.blade.php ENDPATH**/ ?>