<?php $__env->startSection('title', 'تعديل الفاتورة'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen fancy-bg">
  <div class="container mx-auto px-4 md:px-6 lg:px-8 py-10">
    <div class="flex items-center justify-between gap-4 mb-8">
      <h1 class="text-2xl font-bold">تعديل الفاتورة</h1>
      <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-secondary inline-flex items-center gap-2">
        <i class="fa-solid fa-arrow-right"></i>
        <span>عودة للقائمة</span>
      </a>
    </div>

    <?php if($errors->any()): ?>
      <div class="alert alert-danger mb-6">
        <ul class="list-disc ms-5">
          <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('invoices.update', $invoice->id)); ?>" class="space-y-6">
      <?php echo csrf_field(); ?>
      <?php echo method_field('PUT'); ?>

      <div class="card shadow-lg ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-5 mb-6">
        <h2 class="text-lg font-semibold mb-4">بيانات الفاتورة</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
          <div>
            <label class="form-label">رقم الفاتورة</label>
            <input type="text" class="form-input" value="<?php echo e($invoice->number); ?>" readonly />
          </div>
          <div>
            <label class="form-label">التاريخ</label>
            <input type="date" name="date" class="form-input" value="<?php echo e(old('date', optional($invoice->date)->toDateString())); ?>" />
          </div>
          <div>
            <label class="form-label">الحالة</label>
            <select name="status" class="form-select">
              <?php ($currentStatus = old('status', $invoice->status)); ?>
              <option value="غير مسدد" <?php echo e($currentStatus === 'غير مسدد' ? 'selected' : ''); ?>>غير مسدد</option>
              <option value="مسدد" <?php echo e($currentStatus === 'مسدد' ? 'selected' : ''); ?>>مسدد</option>
              <option value="معلق" <?php echo e($currentStatus === 'معلق' ? 'selected' : ''); ?>>معلق</option>
            </select>
          </div>
        </div>
      </div>

      <div class="card shadow-lg ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-5 mb-6">
        <h2 class="text-lg font-semibold mb-4">بيانات العميل</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="form-label">اسم العميل</label>
            <input type="text" name="customer_name" class="form-input" value="<?php echo e(old('customer_name', $invoice->customer_name)); ?>" required />
          </div>
          <div>
            <label class="form-label">رقم الهاتف</label>
            <input type="text" name="customer_phone" class="form-input" value="<?php echo e(old('customer_phone', $invoice->customer_phone)); ?>" required />
          </div>
          <div class="md:col-span-2">
            <label class="form-label">العنوان</label>
            <input type="text" name="customer_address" class="form-input" value="<?php echo e(old('customer_address', $invoice->customer_address)); ?>" />
          </div>
          <div class="md:col-span-2">
            <label class="form-label">الرقم الضريبي</label>
            <input type="text" name="tax_number" class="form-input" value="<?php echo e(old('tax_number', $invoice->tax_number)); ?>" />
          </div>
        </div>
      </div>

      <div class="card shadow-lg ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-5 mb-6">
        <div class="flex items-center justify-between mb-4">
          <h2 class="text-lg font-semibold">بنود الفاتورة</h2>
          <button type="button" class="btn btn-primary inline-flex items-center gap-2" onclick="addItemRow()">
            <i class="fa-solid fa-plus"></i>
            <span>إضافة بند</span>
          </button>
        </div>

        <div class="overflow-hidden rounded-xl border border-neutral-200">
          <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
              <thead class="bg-neutral-50">
                <tr class="text-gray-700">
                  <th class="p-3 text-right w-1/2">الوصف</th>
                  <th class="p-3 text-right w-24">الكمية</th>
                  <th class="p-3 text-right w-32">سعر الوحدة</th>
                  <th class="p-3 text-right w-32">الإجمالي</th>
                  <th class="p-3 text-right w-20">حذف</th>
                </tr>
              </thead>
              <tbody id="itemsTableBody" class="bg-white">
              <?php ($idx = 0); ?>
              <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="border-t">
                  <td class="p-3 align-middle">
                    <input type="text" name="items[<?php echo e($idx); ?>][description]" class="form-input w-full" value="<?php echo e(old("items.$idx.description", $item->description)); ?>" required />
                  </td>
                  <td class="p-3 align-middle">
                    <input type="number" min="1" step="1" name="items[<?php echo e($idx); ?>][quantity]" class="form-input w-full item-qty" value="<?php echo e(old("items.$idx.quantity", $item->quantity)); ?>" required />
                  </td>
                  <td class="p-3 align-middle">
                    <input type="number" min="0" step="0.01" name="items[<?php echo e($idx); ?>][unit_price]" class="form-input w-full item-price" value="<?php echo e(old("items.$idx.unit_price", number_format($item->unit_price, 2, '.', ''))); ?>" required />
                  </td>
                  <td class="p-3 align-middle">
                    <input type="text" class="form-input w-full item-total bg-neutral-50" value="<?php echo e(number_format($item->line_total, 2, '.', '')); ?>" readonly />
                  </td>
                  <td class="p-3 align-middle text-center">
                    <button type="button" class="btn btn-danger inline-flex items-center gap-2" onclick="removeItemRow(this)">
                      <i class="fa-solid fa-trash"></i>
                      <span>حذف</span>
                    </button>
                  </td>
                </tr>
                <?php ($idx++); ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

              <?php if($invoice->items->count() === 0): ?>
                <tr>
                  <td>
                    <input type="text" name="items[0][description]" class="form-input w-full" placeholder="مثال: منتج/خدمة" required />
                  </td>
                  <td>
                    <input type="number" min="1" step="1" name="items[0][quantity]" class="form-input w-full item-qty" value="1" required />
                  </td>
                  <td>
                    <input type="number" min="0" step="0.01" name="items[0][unit_price]" class="form-input w-full item-price" value="0.00" required />
                  </td>
                  <td>
                    <input type="text" class="form-input w-full item-total bg-neutral-50" value="0.00" readonly />
                  </td>
                  <td class="text-center">
                    <button type="button" class="btn btn-danger inline-flex items-center gap-2" onclick="removeItemRow(this)">
                      <i class="fa-solid fa-trash"></i>
                      <span>حذف</span>
                    </button>
                  </td>
                </tr>
              <?php endif; ?>
            </tbody>
            </table>
          </div>
        </div>

        <div class="flex flex-col items-end gap-2 mt-4">
           <div class="w-full md:w-1/2 lg:w-1/3">
             <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50">
               <div class="text-gray-700">الإجمالي الفرعي</div>
               <div class="font-semibold text-gray-900"><span id="invoice_subtotal"><?php echo e(number_format($invoice->subtotal ?? ($invoice->items->sum('line_total')), 2, '.', '')); ?></span> ر.س</div>
             </div>
             <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50 mt-2">
               <div class="text-gray-700">ضريبة القيمة المضافة (15%)</div>
               <div class="font-semibold text-gray-900"><span id="invoice_tax"><?php echo e(number_format($invoice->tax ?? (($invoice->items->sum('line_total')) * 0.15), 2, '.', '')); ?></span> ر.س</div>
             </div>
             <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-violet-50 mt-2">
               <div class="text-violet-700 font-bold">الإجمالي</div>
               <div class="font-extrabold text-violet-700"><span id="invoice_total"><?php echo e(number_format($invoice->total ?? (($invoice->items->sum('line_total')) * 1.15), 2, '.', '')); ?></span> ر.س</div>
             </div>
           </div>
         </div>
      </div>

      <div class="card shadow-lg ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-5 mb-6">
        <h2 class="text-lg font-semibold mb-4">ملاحظات</h2>
        <textarea name="notes" rows="4" class="form-textarea w-full" placeholder="ملاحظات إضافية"><?php echo e(old('notes', $invoice->notes)); ?></textarea>
      </div>

      <div class="flex items-center gap-3">
        <button type="submit" class="btn btn-primary inline-flex items-center gap-2">
          <i class="fa-solid fa-floppy-disk"></i>
          <span>حفظ التغييرات</span>
        </button>
        <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>" class="btn btn-secondary inline-flex items-center gap-2">
          <i class="fa-solid fa-eye"></i>
          <span>عرض الفاتورة</span>
        </a>
      </div>
    </form>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    let itemIndex = <?php echo e(max(1, $invoice->items->count())); ?>;
    const tbody = document.getElementById('itemsTableBody');
    const invoiceSubtotalEl = document.getElementById('invoice_subtotal');
    const invoiceTaxEl = document.getElementById('invoice_tax');
    const invoiceTotalEl = document.getElementById('invoice_total');

    const VAT_RATE = 0.15;
    const format = (num) => Number(num || 0).toFixed(2);

    function updateInvoiceTotal() {
      let subtotal = 0;
      tbody.querySelectorAll('.item-total').forEach(el => {
        subtotal += Number(el.value || 0);
      });
      const tax = subtotal * VAT_RATE;
      const total = subtotal + tax;

      if (invoiceSubtotalEl) invoiceSubtotalEl.textContent = format(subtotal);
      if (invoiceTaxEl) invoiceTaxEl.textContent = format(tax);
      if (invoiceTotalEl) invoiceTotalEl.textContent = format(total);
    }

    function rebindRow(row) {
      const qty = row.querySelector('.item-qty');
      const price = row.querySelector('.item-price');
      const total = row.querySelector('.item-total');

      function recalc() {
        const q = Number(qty?.value || 0);
        const p = Number(price?.value || 0);
        if (total) total.value = format(q * p);
        updateInvoiceTotal();
      }

      qty && qty.addEventListener('input', recalc);
      price && price.addEventListener('input', recalc);

      // حساب أولي عند التحميل
      recalc();
    }

    window.addItemRow = function addItemRow() {
      const tr = document.createElement('tr');
      tr.className = 'border-t';
      tr.innerHTML = `
        <td class="p-3 align-middle">
          <input type="text" name="items[${itemIndex}][description]" class="form-input w-full" placeholder="مثال: منتج/خدمة" required />
        </td>
        <td class="p-3 align-middle">
          <input type="number" min="1" step="1" name="items[${itemIndex}][quantity]" class="form-input w-full item-qty" value="1" required />
        </td>
        <td class="p-3 align-middle">
          <input type="number" min="0" step="0.01" name="items[${itemIndex}][unit_price]" class="form-input w-full item-price" value="0.00" required />
        </td>
        <td class="p-3 align-middle">
          <input type="text" class="form-input w-full item-total bg-neutral-50" value="0.00" readonly />
        </td>
        <td class="p-3 align-middle text-center">
          <button type="button" class="btn btn-danger inline-flex items-center gap-2" onclick="removeItemRow(this)">
            <i class="fa-solid fa-trash"></i>
            <span>حذف</span>
          </button>
        </td>
      `;
      tbody.appendChild(tr);
      itemIndex++;
      rebindRow(tr);
    }

    window.removeItemRow = function removeItemRow(btn) {
      const tr = btn.closest('tr');
      if (tr) {
        tr.remove();
        updateInvoiceTotal();
      }
    }

    // ربط الأحداث بالصفوف الموجودة مسبقًا
    tbody.querySelectorAll('tr').forEach(rebindRow);

    // تحديث الإجمالي عند بداية التحميل
    updateInvoiceTotal();
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoicesystem\resources\views/invoices/edit.blade.php ENDPATH**/ ?>